/*
 * Decompiled with CFR 0.152.
 */
package gloridifice.watersource.common.capability;

import gloridifice.watersource.common.network.PlayerWaterLevelMessage;
import gloridifice.watersource.common.network.SimpleNetworkHandler;
import gloridifice.watersource.registry.ConfigRegistry;
import gloridifice.watersource.registry.DamageSourceRegistry;
import gloridifice.watersource.registry.EffectRegistry;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.world.Difficulty;
import net.minecraft.world.GameRules;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.network.PacketDistributor;

public class WaterLevelCapability {
    @CapabilityInject(value=Data.class)
    public static Capability<Data> PLAYER_WATER_LEVEL;

    public static boolean canPlayerAddWaterExhaustionLevel(PlayerEntity player) {
        return !(player instanceof FakePlayer) && !player.func_184812_l_() && !player.func_175149_v() && player.getCapability(PLAYER_WATER_LEVEL) != null && player.func_130014_f_().func_175659_aa() != Difficulty.PEACEFUL;
    }

    public static class Provider
    implements ICapabilitySerializable<INBT> {
        private Data playerWaterLevel = new Data();
        private Capability.IStorage<Data> storage = PLAYER_WATER_LEVEL.getStorage();

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
            if (cap.equals(PLAYER_WATER_LEVEL)) {
                return LazyOptional.of(() -> this.playerWaterLevel).cast();
            }
            return LazyOptional.empty();
        }

        public INBT serializeNBT() {
            return this.storage.writeNBT(PLAYER_WATER_LEVEL, (Object)this.playerWaterLevel, null);
        }

        public void deserializeNBT(INBT nbt) {
            this.storage.readNBT(PLAYER_WATER_LEVEL, (Object)this.playerWaterLevel, null, nbt);
        }
    }

    public static class Data {
        private int waterLevel = 20;
        private int waterSaturationLevel = 6;
        private float waterExhaustionLevel = 0.0f;

        public void addWaterLevel(PlayerEntity player, int add) {
            this.waterLevel = Math.min(this.waterLevel + add, 20);
            this.update(player);
        }

        public void addWaterSaturationLevel(PlayerEntity player, int add) {
            this.waterSaturationLevel = Math.min(this.waterSaturationLevel + add, 20);
            this.update(player);
        }

        protected void addExhaustion(float add) {
            this.reduceLevel((int)((this.waterExhaustionLevel + add) / 4.0f));
            this.waterExhaustionLevel = (this.waterExhaustionLevel + add) % 4.0f;
        }

        public void addExhaustion(PlayerEntity player, float add) {
            float finalValue = (float)((double)add * (Double)ConfigRegistry.WATER_REDUCING_RATE.get());
            EffectInstance effect = player.func_70660_b(EffectRegistry.THIRST);
            if (effect != null) {
                this.addExhaustion(finalValue * (float)(3 + effect.func_76458_c()) / 2.0f);
            } else {
                this.addExhaustion(finalValue);
            }
            this.update(player);
        }

        public void update(PlayerEntity player) {
            if (!player.func_130014_f_().func_201670_d()) {
                SimpleNetworkHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)player), (Object)new PlayerWaterLevelMessage(this.getWaterLevel(), this.getWaterSaturationLevel(), this.getWaterExhaustionLevel()));
            }
        }

        public void setWaterLevel(int temp) {
            this.waterLevel = temp;
        }

        public void setWaterExhaustionLevel(float waterExhaustionLevel) {
            this.waterExhaustionLevel = waterExhaustionLevel;
        }

        public int getWaterLevel() {
            return this.waterLevel;
        }

        public void setWaterSaturationLevel(int waterSaturationLevel) {
            this.waterSaturationLevel = waterSaturationLevel;
        }

        public int getWaterSaturationLevel() {
            return this.waterSaturationLevel;
        }

        public float getWaterExhaustionLevel() {
            return this.waterExhaustionLevel;
        }

        public void reduceLevel(int reduce) {
            if (this.waterSaturationLevel - reduce >= 0) {
                this.waterSaturationLevel -= reduce;
            } else if (this.waterLevel - (reduce - this.waterSaturationLevel) >= 0) {
                this.waterLevel -= reduce;
                this.waterSaturationLevel = 0;
            } else {
                this.waterLevel = 0;
                this.waterSaturationLevel = 0;
            }
        }

        public void restoreWater(PlayerEntity player, int waterLevel, int waterSaturationLevel) {
            this.addWaterLevel(player, waterLevel);
            this.addWaterSaturationLevel(player, waterSaturationLevel);
        }

        public void restoreWater(int restore) {
            this.waterLevel = Math.min(this.waterLevel + restore, 20);
            if (this.waterLevel == 20) {
                this.waterSaturationLevel = Math.min(this.waterLevel + restore, 20);
            }
        }

        public void award(PlayerEntity player) {
            if (player.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223606_i) && this.getWaterLevel() > 17 && player.func_71024_bL().func_75116_a() > 10 && player.func_110143_aJ() < player.func_110138_aP()) {
                player.func_70691_i(1.0f);
                switch (player.func_130014_f_().func_175659_aa()) {
                    case PEACEFUL: {
                        break;
                    }
                    case EASY: {
                        this.addExhaustion(5.0f);
                        player.func_71020_j(0.6f);
                        break;
                    }
                    case NORMAL: {
                        this.addExhaustion(6.0f);
                        player.func_71020_j(0.8f);
                        break;
                    }
                    case HARD: {
                        this.addExhaustion(7.0f);
                        player.func_71020_j(1.0f);
                    }
                }
            }
        }

        public void punishment(PlayerEntity player) {
            int weAmp = (Integer)ConfigRegistry.WEAKNESS_EFFECT_AMPLIFIER.get();
            int slAmp = (Integer)ConfigRegistry.WEAKNESS_EFFECT_AMPLIFIER.get();
            if (this.getWaterLevel() <= 6) {
                switch (player.func_130014_f_().func_175659_aa()) {
                    case PEACEFUL: {
                        break;
                    }
                    case EASY: {
                        if (weAmp > -1 && (player.func_70660_b(Effects.field_76437_t) == null || player.func_70660_b(Effects.field_76437_t).func_76459_b() <= 100)) {
                            player.func_195064_c(new EffectInstance(Effects.field_76437_t, 400, weAmp, false, false));
                        }
                        if (slAmp <= -1 || player.func_70660_b(Effects.field_76421_d) != null && player.func_70660_b(Effects.field_76421_d).func_76459_b() > 100) break;
                        player.func_195064_c(new EffectInstance(Effects.field_76421_d, 400, slAmp, false, false));
                        break;
                    }
                    default: {
                        if (weAmp > -1 && (player.func_70660_b(Effects.field_76437_t) == null || player.func_70660_b(Effects.field_76437_t).func_76459_b() <= 100)) {
                            player.func_195064_c(new EffectInstance(Effects.field_76437_t, 400, weAmp + 1, false, false));
                        }
                        if (slAmp <= -1 || player.func_70660_b(Effects.field_76421_d) != null && player.func_70660_b(Effects.field_76421_d).func_76459_b() > 100) break;
                        player.func_195064_c(new EffectInstance(Effects.field_76421_d, 400, slAmp, false, false));
                    }
                }
            }
            boolean i = false;
            if (player.func_130014_f_().func_175659_aa() != Difficulty.HARD) {
                i = true;
            }
            if (this.getWaterLevel() == 0 && player.func_110143_aJ() > (float)i) {
                if (!player.func_130014_f_().func_201670_d()) {
                    player.func_70097_a(DamageSourceRegistry.BY_THIRST, 1.0f);
                } else {
                    player.func_130014_f_().func_184133_a(player, player.func_233580_cy_(), SoundEvents.field_187675_cd, SoundCategory.PLAYERS, 1.0f, 1.0f);
                }
            }
        }
    }

    public static class Storage
    implements Capability.IStorage<Data> {
        public INBT writeNBT(Capability<Data> capability, Data instance, Direction side) {
            CompoundNBT compound = new CompoundNBT();
            compound.func_74768_a("PlayerWaterLevel", instance.getWaterLevel());
            compound.func_74768_a("PlayerWaterSaturationLevel", instance.getWaterSaturationLevel());
            compound.func_74776_a("PlayerWaterExhaustionLevel", instance.getWaterExhaustionLevel());
            return compound;
        }

        public void readNBT(Capability<Data> capability, Data instance, Direction side, INBT nbt) {
            instance.setWaterLevel(((CompoundNBT)nbt).func_74762_e("PlayerWaterLevel"));
            instance.setWaterSaturationLevel(((CompoundNBT)nbt).func_74762_e("PlayerWaterSaturationLevel"));
            instance.setWaterExhaustionLevel(((CompoundNBT)nbt).func_74760_g("PlayerWaterExhaustionLevel"));
        }
    }
}

